// FIle HIB.cp
//
// Description: This file contains the data manipulation
//              classes for the HIB system.
//

#include "applib.h"
#include <iostream.h>
#include <fstream.h>
#include "Grapher.h"

//
//     Define character manipulation primatives for getting
//     attribute names and and attribute values:
//


//
// String equality comparison. Ignore case.
//

int STR_EQUAL(char *s1, char *s2, int num_to_compare)
{
    for (int i=0; i<num_to_compare; i++) {
        int c1 = s1[i];
        if (c1 >= 'a' && c1 <= 'z')  c1 += 'A' - 'a';
        int c2 = s2[i];
        if (c2 >= 'a' && c2 <= 'z')  c2 += 'A' - 'a';
        if (c1 != c2)  return 0;
    }
    return 1;
}

int get_attribute_value(char *buf, char *attribute,
                        char *returned_value,
                        int len_returned_value)
{
    int alen = strlen(attribute);
    int blen = strlen(buf);
    for (int i=0; i< (blen - alen); i++) 
    {
        if (STR_EQUAL(&(buf[i]), attribute, alen)) 
        {
            // found the attribute name:
            if (buf[i+alen] != ':')  break;

            // find the starting position of the
            // next attribute:
            for (int index = i + alen + 2;
                 index < blen; index++) 
            {
                if (buf[index] ==':')
                {
                    int end = index -1;
                    for (int j=index-1; j>i+alen+1; j--) 
                    {
                        end = j - 1;
                        if (buf[j] == ' ')  break; // exit the
                                                   // for loop
                    }
                    int len2 = end - (i+alen+2)  + 1;

                    // make sure we don't write past the end
                    // of the returned_value buffer:
                    if (len2 > len_returned_value)
                        len2 = len_returned_value;
                    for (int k=0; k<len2; k++) 
                        returned_value[k] = buf[k+i+alen+2];
                    returned_value[len2] = '\0';
                    return 1;
                }
            }

            // no following attribute, simply copy the rest
            // of buf to the returned_value buffer:
            int len2 = blen - (i+alen+2) + 2;

            // make sure we don't write past the end of the
            // returned_value buffer:
            if (len2 > len_returned_value)
                len2 = len_returned_value;
            for (int k=0; k<len2; k++)
                returned_value[k] = buf[k+i+alen+2];
            returned_value[len2] = '\0';
            return 1;
        }
    }
    return 0;
}

TGraph *my_graph = (TGraph *)NULL;

char my_text[100];

void TAppWindow::update_display()
{
    if (my_graph != (TGraph *)NULL)
        my_graph->Draw();
    plot_string(30, 30, my_text);
}

int selected_node = -1;

void TAppWindow::mouse_down(int x, int y)
{
    int node_id = my_graph->closestNode(x, y);
    my_graph->setSelection(node_id);
           // if node_id = -1, this deselects all nodes

    selected_node = node_id;
    clear_display();
    update_display();
}

void TAppWindow::mouse_up(int, int)
{
}

void TAppWindow::mouse_move(int, int)
{
}

void TAppWindow::idle_proc()
{
}

void TAppWindow::do_menu_action(int item_number)
{
    if (item_number == 1) {
        // load an ASCII file:
        if (my_graph == (TGraph *)NULL)
            my_graph = new TGraph(this, "HIB");
        else { // zap old tree:
            my_graph->set_number_of_nodes(1);
                      // keep only the root node
        }
        char file_name[128];
        if (choose_file_to_read("Load ASCII file",
                                "hib", 
                                file_name))
        {
            Warning("Error opening file");
        }  else
        {
            filebuf in_file;
            if (in_file.open(file_name, input)==0)
            {
                char buf5[128];
                sprintf(buf5,
                        "Could not open input file %s",
                        file_name);
                Warning(buf5);
                exit(1);
            }
            // read the file:
            istream in_stream(&in_file);
            char buffer[128];
            char name[50], parent[50];
            in_stream.getline(buffer,255);
            while (!in_stream.eof())
            {
                if (get_attribute_value(buffer,
                                        "name", 
                                        name,
                                        50))
                {
                    if (get_attribute_value(buffer,
                                            "parent",
                                            parent,
                                            50)) 
                    {
                        my_graph->add_child(name, parent);
                    }  else  {
                        my_graph->add_child(name, "HIB");
                    }
                    int my_id = my_graph->name_to_id(name);
                    if (my_id>-1) 
                    {
                        my_graph->set_private_data(my_id,
                                    new char[strlen(buffer)+1]);
                        sprintf(my_graph->get_private_data(my_id),
                                "%s",buffer);
                    }
                }
                in_stream.getline(buffer,255);
            }
            in_file.close();
         }
         my_graph->do_layout();
         clear_display();
         update_display();
    }
    if (item_number == 2)  // Save to file
    {
        char file_name[128];
        if (choose_file_to_write("Save ASCII file",
                                 file_name))
        {
            Warning("Error opening file");
        }  else
        {
            filebuf out_file;
            if (out_file.open(file_name, output)==0) 
            {
                char buf5[128];
                sprintf(buf5,
                        "Could not open input file %s",
                        file_name);
                Warning(buf5);
                exit(1);
            }

            // write the file:
            ostream out_stream(&out_file);
            char buf[256];
            for (int i=0; i<my_graph->get_number_of_nodes(); i++)
            {
                sprintf(buf,
                        "%s\n",
                        my_graph->get_private_data(i));
                out_stream.write(buf, strlen(buf));
            }
            out_file.close();
         }
    }
    if (item_number == 3)  // Clear database in memory
    {
        my_graph->set_number_of_nodes(1);
        clear_display();
        update_display();
    }
    if (item_number == 4)  // Redraw from selected node
    {
        int sel = my_graph->getSelectedNode();
        if (sel > -1) {
            my_graph->do_layout(sel);
            clear_display();
            update_display();
        }
    }
    if (item_number == 5)  // Reset display from root of tree
    {
        my_graph->do_layout();
        clear_display();
        update_display();
    }
    if (item_number == 6)  // Search mode
    {
        char buf[128];
        buf[0] = '\0';
        do_edit("Enter search string for node name or data:",
                buf);
        int len = strlen(buf);
        if (len > 1)
        {
            // count the number of occurences of
            // this string in the database:
            int count = 0;
            int *indices =
                new int[my_graph->get_number_of_nodes() + 1];
            for (int k=0; k<my_graph->get_number_of_nodes(); k++) 
            {
                int len2 = strlen(my_graph->get_private_data(k));
                for (int i=0; i<len2 - len + 1; i++)
                if (my_graph->get_private_data(i) != NULL) {
                    if (STR_EQUAL((char *)(my_graph->get_private_data(k)+i),
                                  buf, len))
                        indices[count++] = k;
                }
            }
            if (count > 0) 
            {
                char **cp = new char *[count + 1];
                for (int i = 0; i<count; i++)
                    cp[i] = my_graph->get_private_data(indices[i]);
                int sel2 = choose_one_from_list("Choose one:",
                                                cp,
                                                count);
                if (sel2 > -1) 
                {
                    int selected_node_index = indices[sel2];
                    // choose the top node of the display to
                    // be the parent node of this selected node,
                    // IF the parent exists:
                    int top = 
                       my_graph->get_parent_id(selected_node_index);
                    if (top == -1) 
                       top = selected_node_index;
                    my_graph->do_layout(top);
                    my_graph->setSelection(selected_node_index);
                    selected_node = selected_node_index;
                    clear_display();
                    update_display();
                }
                delete indices;
                delete cp;
            }
        }
    }
    if (item_number == 7)  //  Edit selected node
    {
        if (selected_node > -1) 
        {
            char buf[128];
            sprintf(buf,
                    "%s",
                     my_graph->get_private_data(selected_node));
            delete my_graph->get_private_data(selected_node);
            do_edit("Node edit:",
                    buf);
            my_graph->set_private_data(selected_node,
                                       new char[strlen(buf)+1]);
            sprintf(my_graph->get_private_data(selected_node),
                                               "%s",
                                               buf);
        }
    }
    if (item_number == 8)  //  Delete selected node
    {
        if (selected_node > -1) 
        {
            // update all parent pointers:
            for (int i=0; i<my_graph->get_number_of_nodes();
                 i++) 
            {
                if (my_graph->get_parent_id(i) == selected_node)
                    my_graph->set_parent_id(i, 0);
                                 // point to root of tree
                if (my_graph->get_parent_id(i) > selected_node)
                    my_graph->set_parent_id(i,
                                            my_graph->get_parent_id(i)-1);
            }

            // remove the selected node:
            for (i=selected_node; i<my_graph->get_number_of_nodes()-1;
                 i++)
            {
                my_graph->copy_node(i, i+1);
            }

            // decrement the number of nodes by 1:
            my_graph->set_number_of_nodes(
                        my_graph->get_number_of_nodes() - 1);
            my_graph->do_layout();
            my_graph->setSelection(-1);
            selected_node = -1;
            clear_display();
            update_display();
        }
    }
    if (item_number == 9)  //  Create a new node
    {
        char buf[128];
        sprintf(buf,"name: <a name> parent: <a parent node>");
        do_edit("Make a new node:", buf);
        char name[50], parent[50];
        if (get_attribute_value(buf, "name", name, 50))  
        {
            if (get_attribute_value(buf,
                                    "parent",
                                    parent, 50))
            {
                my_graph->add_child(name, parent);
                int my_id = my_graph->name_to_id(name);
                my_graph->set_private_data(my_id,
                                           new char[strlen(buf)+1]);
                sprintf(my_graph->get_private_data(my_id),
                        "%s",
                        buf);
                my_graph->do_layout();
                my_graph->setSelection(-1);
                selected_node = -1;
                clear_display();
                update_display();
            } else show_info("No parent node specified");
        }  else show_info("No node name specified");
    }
    if (item_number == 10) {  //  Quit
        exit(0);
    }
}


static char *menu_items[] =
    {"Load ASCII file",
     "Save database to ASCII file",
     "Clear database",
     "Redraw from selected node",
     "Reset display from root of tree",
     "Search mode",
     "Edit selected node",
     "Delete selected node",
     "Create new node"
    };

INIT_PROGRAM("HIB", 9, menu_items)
   // Any application specific initialization code goes here

   my_text[0] = '\0';
   Application::text_from_dialog[0] = '\0';
   Application::number_of_dialog_list_items = 0;
   RUN_PROGRAM;
}
